-- change directory to program location
parse source  . . pgm
call directory filespec('L', pgm) 

-- create a new document and add a blank page
doc=.bsf~new("org.apache.pdfbox.pdmodel.PDDocument")
page=.bsf~new("org.apache.pdfbox.pdmodel.PDPage")
doc~addPage(page)

-- create a content stream
contclass = "org.apache.pdfbox.pdmodel.PDPageContentStream"
cont=.bsf~new(contclass,doc,page)
cont~setLineWidth(1)

-- draw a line
cont~moveTo(100,700)
cont~lineTo(250,700)

-- draw a curve
cont~moveTo(350,700)
cont~curveTo(380,720,420,750,500,700)

-- draw a rectangle
cont~addRect(120,600,100,-100)

-- draw a triangle
cont~moveTo(350,500)
cont~lineTo(450,500)
cont~lineTo(400,600)
cont~lineTo(350,500)

-- draw a star shape
cont~moveTo(120,360)
cont~lineTo(220,360)
cont~lineTo(140,300)
cont~lineTo(170,400)
cont~lineTo(200,300)
cont~lineTo(120,360)

-- draw a circle
cx=400
cy=350
r=50
k=0.552284749831
cont~moveTo(cx-r,cy)
cont~curveTo(cx-r,cy+k*r,cx-k*r,cy+r,cx,cy+r)
cont~curveTo(cx+k*r,cy+r,cx+r,cy+k*r,cx+r,cy)
cont~curveTo(cx+r,cy-k*r,cx+k*r,cy-r,cx,cy-r)
cont~curveTo(cx-k*r,cy-r,cx-r,cy-k*r,cx-r,cy)

-- make all the drawed shapes visible
cont~stroke
cont~close

-- save and close the document file
doc~save("05-shapes.pdf")
doc~close

-- get java support
::requires "BSF.CLS"